/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ElementMemories;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoint;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.properties.RuntimePropertyContainer;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8824;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractElement
implements class_4068,
class_364,
class_6379,
NavigatableWidget {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final AbstractElement EMPTY_ELEMENT = new AbstractElement(null){

        @Override
        public void method_25394(@NotNull class_332 g, int i1, int i2, float f) {
        }
    };
    public static final int STAY_ON_SCREEN_EDGE_ZONE_SIZE = 2;
    public final ElementBuilder<?, ?> builder;
    public ElementAnchorPoint anchorPoint = ElementAnchorPoints.MID_CENTERED;
    protected String anchorPointElementIdentifier = null;
    protected AbstractElement cachedElementAnchorPointParent = null;
    public int posOffsetX = 0;
    public int posOffsetY = 0;
    public int baseWidth = 0;
    public int baseHeight = 0;
    public String advancedX;
    public Integer cachedAdvancedX;
    public long lastAdvancedXParse = -1L;
    public String advancedY;
    public Integer cachedAdvancedY;
    public long lastAdvancedYParse = -1L;
    public String advancedWidth;
    public Integer cachedAdvancedWidth;
    public long lastAdvancedWidthParse = -1L;
    public String advancedHeight;
    public Integer cachedAdvancedHeight;
    public long lastAdvancedHeightParse = -1L;
    public boolean stretchX = false;
    public boolean stretchY = false;
    public boolean stayOnScreen = true;
    public volatile boolean visible = true;
    public volatile AppearanceDelay appearanceDelay = AppearanceDelay.NO_DELAY;
    public volatile float appearanceDelayInSeconds = 1.0f;
    public long appearanceDelayEndTime = -1L;
    @NotNull
    public Fading fadeIn = Fading.NO_FADING;
    @NotNull
    public Fading fadeOut = Fading.NO_FADING;
    public float fadeInSpeed = 1.0f;
    public float fadeOutSpeed = 1.0f;
    public boolean shouldDoFadeInIfNeeded = false;
    public boolean fadeInStarted = false;
    public boolean fadeInFinished = false;
    public boolean shouldDoFadeOutIfNeeded = false;
    public boolean fadeOutStarted = false;
    public boolean fadeOutFinished = false;
    public long lastFadeInTick = -1L;
    public long lastFadeOutTick = -1L;
    public float opacity = 1.0f;
    @NotNull
    public String baseOpacity = "1.0";
    public float lastBaseOpacity = -1.0f;
    public long lastBaseOpacityParse = -1L;
    public float cachedBaseOpacity = 1.0f;
    public boolean becameVisible = false;
    public boolean becameInvisible = false;
    public boolean isNewMenu = ScreenCustomization.isNewMenu();
    public boolean fadeInElementJustCreated = true;
    public boolean fadeOutElementJustCreated = true;
    public boolean appearanceDelayElementJustCreated = true;
    public boolean lastTickAppearanceDelayed = false;
    public boolean autoSizing = false;
    public int autoSizingBaseScreenWidth = 0;
    public int autoSizingBaseScreenHeight = 0;
    public double autoSizingLastTickScreenWidth = -1.0;
    public double autoSizingLastTickScreenHeight = -1.0;
    public int autoSizingWidth = 0;
    public int autoSizingHeight = 0;
    public boolean stickyAnchor = false;
    public int animatedOffsetX = 0;
    public int animatedOffsetY = 0;
    public float customGuiScale = -1.0f;
    public LoadingRequirementContainer loadingRequirementContainer = new LoadingRequirementContainer();
    @Nullable
    public String customElementLayerName = null;
    public boolean enableParallax = false;
    public boolean invertParallax = false;
    @NotNull
    public String parallaxIntensityString = "0.5";
    public float lastParallaxIntensity = -10000.0f;
    public boolean loadOncePerSession = false;
    @NotNull
    public DrawableColor inEditorColor = DrawableColor.of(Color.ORANGE);
    public boolean layerHiddenInEditor = false;
    private String instanceIdentifier;
    @Nullable
    protected Layout parentLayout;
    @Nullable
    protected RuntimePropertyContainer cachedMemory;
    protected int cachedMouseX = 0;
    protected int cachedMouseY = 0;

    public AbstractElement(@NotNull ElementBuilder<?, ?> builder) {
        this.builder = builder;
        this.instanceIdentifier = ScreenCustomization.generateUniqueIdentifier();
    }

    public void setParentLayout(@Nullable Layout parentLayout) {
        this.parentLayout = parentLayout;
    }

    @Nullable
    public Layout getParentLayout() {
        return this.parentLayout;
    }

    public void afterConstruction() {
    }

    public abstract void method_25394(@NotNull class_332 var1, int var2, int var3, float var4);

    public void renderInternal(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.cachedMouseX = mouseX;
        this.cachedMouseY = mouseY;
        this.lastParallaxIntensity = SerializationUtils.deserializeNumber(Float.class, Float.valueOf(0.5f), PlaceholderParser.replacePlaceholders(this.parallaxIntensityString)).floatValue();
        this.tickBaseOpacity();
        this.renderTick_Head();
        this.tickVisibleInvisible();
        this.renderTick_Inner_Stage_1();
        if (!AbstractElement.isEditor()) {
            this.tickAppearanceDelay(this.shouldRender());
            this.tickFadeInOut(this.shouldRender());
        }
        if (!this.shouldRender()) {
            return;
        }
        this.renderTick_Inner_Stage_2();
        this.method_25394(graphics, mouseX, mouseY, partial);
        this.renderTick_Tail();
    }

    public void renderTick_Head() {
    }

    public void renderTick_Inner_Stage_1() {
    }

    public void renderTick_Inner_Stage_2() {
    }

    public void renderTick_Tail() {
    }

    public void tickBaseOpacity() {
        if (this.fadeInStarted && !this.fadeInFinished) {
            return;
        }
        if (this.fadeOutStarted && !this.fadeOutFinished) {
            return;
        }
        float newBaseOpacity = this.getBaseOpacity();
        if (newBaseOpacity != this.lastBaseOpacity) {
            this.updateOpacity();
        }
        this.lastBaseOpacity = newBaseOpacity;
    }

    public void tickVisibleInvisible() {
        if (!this._shouldRender()) {
            if (!this.becameInvisible) {
                this.becameInvisible = true;
                this.onBecomeInvisible();
            }
            this.becameVisible = false;
            return;
        }
        this.becameInvisible = false;
        if (!this.becameVisible) {
            this.becameVisible = true;
            this.onBecomeVisible();
        }
    }

    public void tickAppearanceDelay(boolean shouldRender) {
        if (!shouldRender) {
            return;
        }
        if (this.lastTickAppearanceDelayed && !this.isAppearanceDelayed()) {
            this.getMemory().putProperty("appearance_delay_applied", true);
        }
        this.lastTickAppearanceDelayed = this.isAppearanceDelayed();
    }

    public void tickFadeInOut(boolean shouldRender) {
        if (shouldRender) {
            boolean fadeInIsResize = !this.isNewMenu && this.fadeInElementJustCreated;
            boolean fadeInDone = this.getMemory().putPropertyIfAbsentAndGet("fade_in_done", false);
            if (!fadeInIsResize || !fadeInDone) {
                if (this.fadeIn != Fading.NO_FADING && this.shouldDoFadeInIfNeeded && this.lastBaseOpacity > 0.0f && (this.fadeIn != Fading.FIRST_TIME || !this.getMemory().putPropertyIfAbsentAndGet("fade_in_done", false).booleanValue())) {
                    if (!this.fadeInStarted) {
                        this.fadeInStarted = true;
                        this.opacity = 0.02f;
                        this.lastFadeInTick = System.currentTimeMillis();
                    }
                    long now = System.currentTimeMillis();
                    float elapsedSeconds = (float)(now - this.lastFadeInTick) / 1000.0f;
                    this.lastFadeInTick = now;
                    this.opacity += elapsedSeconds * (0.4f * this.fadeInSpeed);
                    this.opacity = Math.max(0.02f, this.opacity);
                    if (this.opacity >= this.lastBaseOpacity) {
                        this.opacity = this.lastBaseOpacity;
                        this.shouldDoFadeInIfNeeded = false;
                        this.fadeInFinished = true;
                        this.getMemory().putProperty("fade_in_done", true);
                    }
                }
            } else {
                this.shouldDoFadeInIfNeeded = false;
                this.fadeInStarted = false;
                this.fadeInFinished = false;
            }
        }
        this.fadeInElementJustCreated = false;
        if (this.fadeOut != Fading.NO_FADING && this.shouldDoFadeOutIfNeeded && this.lastBaseOpacity > 0.0f && !this.fadeOutFinished) {
            boolean fadeOutDone = this.getMemory().putPropertyIfAbsentAndGet("fade_out_done", false);
            if (this.fadeOut != Fading.FIRST_TIME || !fadeOutDone) {
                if (!this.fadeOutStarted) {
                    this.fadeOutStarted = true;
                    this.opacity = this.lastBaseOpacity;
                    this.lastFadeOutTick = System.currentTimeMillis();
                }
                long now = System.currentTimeMillis();
                float elapsedSeconds = (float)(now - this.lastFadeOutTick) / 1000.0f;
                this.lastFadeOutTick = now;
                this.opacity -= elapsedSeconds * (0.4f * this.fadeOutSpeed);
                this.opacity = Math.max(0.02f, this.opacity);
                if (this.opacity <= 0.02f) {
                    this.opacity = 0.02f;
                    this.shouldDoFadeOutIfNeeded = false;
                    this.fadeOutFinished = true;
                    this.getMemory().putProperty("fade_out_done", true);
                }
            }
        }
    }

    public void onBecomeVisible() {
        this.applyAppearanceDelay();
        this.updateOpacity();
        this.fadeInStarted = false;
        this.fadeInFinished = false;
        this.fadeOutStarted = false;
        this.fadeOutFinished = false;
        this.shouldDoFadeInIfNeeded = true;
        this.shouldDoFadeOutIfNeeded = false;
    }

    public void onBecomeInvisible() {
        this.updateOpacity();
        this.fadeInStarted = false;
        this.fadeInFinished = false;
        this.fadeOutStarted = false;
        this.fadeOutFinished = false;
        this.shouldDoFadeOutIfNeeded = true;
        this.shouldDoFadeInIfNeeded = false;
        if (this.fadeOutElementJustCreated) {
            this.shouldDoFadeOutIfNeeded = false;
        }
        this.fadeOutElementJustCreated = false;
    }

    public void applyAppearanceDelay() {
        boolean isResize = !this.isNewMenu && this.appearanceDelayElementJustCreated;
        this.appearanceDelayElementJustCreated = false;
        if (AbstractElement.isEditor()) {
            this.appearanceDelayEndTime = -1L;
            return;
        }
        boolean applied = this.getMemory().putPropertyIfAbsentAndGet("appearance_delay_applied", false);
        this.appearanceDelayEndTime = !(isResize && applied || this.appearanceDelay == AppearanceDelay.NO_DELAY || !(this.appearanceDelayInSeconds > 0.0f)) ? (this.appearanceDelay == AppearanceDelay.FIRST_TIME && applied ? -1L : System.currentTimeMillis() + (long)(this.appearanceDelayInSeconds * 1000.0f)) : -1L;
        this.lastTickAppearanceDelayed = this.isAppearanceDelayed();
    }

    public void updateOpacity() {
        this.opacity = this.getBaseOpacity();
    }

    public float getBaseOpacity() {
        long now = System.currentTimeMillis();
        if (this.lastBaseOpacityParse + 30L > now) {
            return this.cachedBaseOpacity;
        }
        this.lastBaseOpacityParse = now;
        String s = PlaceholderParser.replacePlaceholders(this.baseOpacity);
        if (MathUtils.isFloat((String)s)) {
            float f = Float.parseFloat(s);
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            this.cachedBaseOpacity = f;
            return f;
        }
        this.cachedBaseOpacity = 1.0f;
        return 1.0f;
    }

    public void tick() {
    }

    public void onCloseScreen(@Nullable class_437 closedScreen, @Nullable class_437 newScreen) {
    }

    @Deprecated
    public void onCloseScreen() {
    }

    public void onOpenScreen() {
    }

    @ApiStatus.Internal
    public void _onOpenScreen() {
        this.onOpenScreen();
    }

    public void onBeforeResizeScreen() {
    }

    public void onDestroyElement() {
    }

    @Nullable
    public List<class_364> getWidgetsToRegister() {
        return null;
    }

    @NotNull
    public String getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    public void setInstanceIdentifier(@NotNull String id) {
        this.instanceIdentifier = Objects.requireNonNull(id);
    }

    public int getAbsoluteX() {
        boolean applyParallax;
        int x = 0;
        if (this.anchorPoint != null) {
            x = this.anchorPoint.getElementPositionX(this);
        }
        if (this.advancedX != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedXParse + 30L > now && this.cachedAdvancedX != null) {
                x = this.cachedAdvancedX;
            } else {
                String s = PlaceholderParser.replacePlaceholders(this.advancedX).replace(" ", "");
                if (MathUtils.isDouble((String)s)) {
                    x = (int)Double.parseDouble(s);
                    this.cachedAdvancedX = x;
                    this.lastAdvancedXParse = now;
                }
            }
        }
        x += this.animatedOffsetX;
        boolean bl = applyParallax = this.enableParallax && !AbstractElement.isEditor();
        if (applyParallax) {
            float centerX = (float)AbstractElement.getScreenWidth() / 2.0f;
            float offsetX = (float)this.cachedMouseX - centerX;
            float parallaxOffset = offsetX * this.lastParallaxIntensity * 0.1f;
            x += (int)(this.invertParallax ? parallaxOffset : -parallaxOffset);
        }
        if (this.stretchX) {
            x = 0;
        } else if (this.stayOnScreen && !this.stickyAnchor && !applyParallax) {
            if (x < 2) {
                x = 2;
            }
            if (x > AbstractElement.getScreenWidth() - 2 - this.getAbsoluteWidth()) {
                x = AbstractElement.getScreenWidth() - 2 - this.getAbsoluteWidth();
            }
        }
        return x;
    }

    public int getAbsoluteY() {
        boolean applyParallax;
        int y = 0;
        if (this.anchorPoint != null) {
            y = this.anchorPoint.getElementPositionY(this);
        }
        if (this.advancedY != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedYParse + 30L > now && this.cachedAdvancedY != null) {
                y = this.cachedAdvancedY;
            } else {
                String s = PlaceholderParser.replacePlaceholders(this.advancedY).replace(" ", "");
                if (MathUtils.isDouble((String)s)) {
                    y = (int)Double.parseDouble(s);
                    this.cachedAdvancedY = y;
                    this.lastAdvancedYParse = now;
                }
            }
        }
        y += this.animatedOffsetY;
        boolean bl = applyParallax = this.enableParallax && !AbstractElement.isEditor();
        if (applyParallax) {
            float centerY = (float)AbstractElement.getScreenHeight() / 2.0f;
            float offsetY = (float)this.cachedMouseY - centerY;
            float parallaxOffset = offsetY * this.lastParallaxIntensity * 0.1f;
            y += (int)(this.invertParallax ? parallaxOffset : -parallaxOffset);
        }
        if (this.stretchY) {
            y = 0;
        } else if (this.stayOnScreen && !this.stickyAnchor && !applyParallax) {
            if (y < 2) {
                y = 2;
            }
            if (y > AbstractElement.getScreenHeight() - 2 - this.getAbsoluteHeight()) {
                y = AbstractElement.getScreenHeight() - 2 - this.getAbsoluteHeight();
            }
        }
        return y;
    }

    public int getAbsoluteWidth() {
        if (this.advancedWidth != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedWidthParse + 30L > now && this.cachedAdvancedWidth != null) {
                return this.cachedAdvancedWidth;
            }
            String s = PlaceholderParser.replacePlaceholders(this.advancedWidth).replace(" ", "");
            if (MathUtils.isDouble((String)s)) {
                this.cachedAdvancedWidth = (int)Double.parseDouble(s);
                this.lastAdvancedWidthParse = now;
                return this.cachedAdvancedWidth;
            }
        }
        if (this.stretchX) {
            return AbstractElement.getScreenWidth();
        }
        this.updateAutoSizing(false);
        if (this.autoSizing && this.autoSizingWidth > 0) {
            return this.autoSizingWidth;
        }
        return this.baseWidth;
    }

    public int getAbsoluteHeight() {
        if (this.advancedHeight != null) {
            long now = System.currentTimeMillis();
            if (this.lastAdvancedHeightParse + 30L > now && this.cachedAdvancedHeight != null) {
                return this.cachedAdvancedHeight;
            }
            String s = PlaceholderParser.replacePlaceholders(this.advancedHeight).replace(" ", "");
            if (MathUtils.isDouble((String)s)) {
                this.cachedAdvancedHeight = (int)Double.parseDouble(s);
                this.lastAdvancedHeightParse = now;
                return this.cachedAdvancedHeight;
            }
        }
        if (this.stretchY) {
            return AbstractElement.getScreenHeight();
        }
        this.updateAutoSizing(false);
        if (this.autoSizing && this.autoSizingHeight > 0) {
            return this.autoSizingHeight;
        }
        return this.baseHeight;
    }

    public void setAutoSizingBaseWidthAndHeight() {
        class_1041 window = class_310.method_1551().method_22683();
        double guiWidth = AbstractElement.getScreenWidth() * window.method_4495();
        double guiHeight = AbstractElement.getScreenHeight() * window.method_4495();
        this.autoSizingBaseScreenWidth = (int)guiWidth;
        this.autoSizingBaseScreenHeight = (int)guiHeight;
    }

    public void updateAutoSizing(boolean ignoreLastTickScreenSize) {
        class_1041 window = class_310.method_1551().method_22683();
        double guiWidth = AbstractElement.getScreenWidth() * window.method_4495();
        double guiHeight = AbstractElement.getScreenHeight() * window.method_4495();
        if (this.autoSizingLastTickScreenWidth != guiWidth || this.autoSizingLastTickScreenHeight != guiHeight || ignoreLastTickScreenSize) {
            if (this.autoSizing && this.autoSizingBaseScreenWidth > 0 && this.autoSizingBaseScreenHeight > 0) {
                double percentX = Math.max(1.0, guiWidth / (double)this.autoSizingBaseScreenWidth * 100.0);
                double percentY = Math.max(1.0, guiHeight / (double)this.autoSizingBaseScreenHeight * 100.0);
                double percent = Math.min(percentX, percentY);
                this.autoSizingWidth = Math.max(1, (int)(percent / 100.0 * (double)this.baseWidth));
                this.autoSizingHeight = Math.max(1, (int)(percent / 100.0 * (double)this.baseHeight));
                if ((double)this.autoSizingBaseScreenWidth == guiWidth && (double)this.autoSizingBaseScreenHeight == guiHeight) {
                    this.autoSizingWidth = 0;
                    this.autoSizingHeight = 0;
                }
            } else {
                this.autoSizingWidth = 0;
                this.autoSizingHeight = 0;
            }
        }
        this.autoSizingLastTickScreenWidth = guiWidth;
        this.autoSizingLastTickScreenHeight = guiHeight;
    }

    @Nullable
    public String getAnchorPointElementIdentifier() {
        return this.anchorPointElementIdentifier;
    }

    public void setAnchorPointElementIdentifier(@Nullable String anchorPointElementIdentifier) {
        if (anchorPointElementIdentifier == null || anchorPointElementIdentifier.trim().isEmpty()) {
            this.anchorPointElementIdentifier = null;
            this.cachedElementAnchorPointParent = null;
            return;
        }
        String normalizedIdentifier = anchorPointElementIdentifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
        if (this.getInstanceIdentifier().equals(normalizedIdentifier)) {
            this.resetToDefaultAnchor();
            LOGGER.error("[FANCYMENU] Tried to anchor element to itself! (Element: " + this.getInstanceIdentifier() + ")", (Throwable)new IllegalStateException("Anchoring element to itself"));
            return;
        }
        AbstractElement parent = AbstractElement.getElementByInstanceIdentifier(normalizedIdentifier);
        if (parent != null && this.detectCircularDependency(this, parent)) {
            this.resetToDefaultAnchor();
            LOGGER.error("[FANCYMENU] Detected circular anchor dependency! Cannot anchor '" + this.getInstanceIdentifier() + "' to '" + normalizedIdentifier + "' as it would create a circular reference chain.", (Throwable)new IllegalStateException("Circular anchor dependency detected"));
            return;
        }
        this.anchorPointElementIdentifier = normalizedIdentifier;
        this.cachedElementAnchorPointParent = parent;
    }

    protected boolean detectCircularDependency(AbstractElement child, AbstractElement proposedParent) {
        int depth;
        int MAX_DEPTH = 100;
        HashSet<String> visitedElements = new HashSet<String>();
        visitedElements.add(child.getInstanceIdentifier());
        AbstractElement current = proposedParent;
        for (depth = 0; current != null && depth < 100; ++depth) {
            String currentId = current.getInstanceIdentifier();
            if (visitedElements.contains(currentId)) {
                return true;
            }
            visitedElements.add(currentId);
            String parentId = current.getAnchorPointElementIdentifier();
            if (parentId == null || parentId.trim().isEmpty()) break;
            parentId = parentId.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
            current = AbstractElement.getElementByInstanceIdentifier(parentId);
        }
        if (depth >= 100) {
            LOGGER.warn("[FANCYMENU] Anchor chain depth exceeded 100 levels while checking for circular dependencies. This might indicate a problem.");
            return true;
        }
        return false;
    }

    public void resetToDefaultAnchor() {
        this.anchorPointElementIdentifier = null;
        this.cachedElementAnchorPointParent = null;
        this.anchorPoint = ElementAnchorPoints.MID_CENTERED;
        this.posOffsetX = 0;
        this.posOffsetY = 0;
    }

    @Nullable
    public AbstractElement getElementAnchorPointParent() {
        if (this.anchorPointElementIdentifier == null) {
            return null;
        }
        if (this.cachedElementAnchorPointParent == null) {
            this.cachedElementAnchorPointParent = AbstractElement.getElementByInstanceIdentifier(this.anchorPointElementIdentifier);
        }
        return this.cachedElementAnchorPointParent;
    }

    public void setElementAnchorPointParent(@Nullable AbstractElement element) {
        if (this.anchorPointElementIdentifier == null) {
            element = null;
        }
        this.cachedElementAnchorPointParent = element;
    }

    public int getChildElementAnchorPointX() {
        return this.getAbsoluteX();
    }

    public int getChildElementAnchorPointY() {
        return this.getAbsoluteY();
    }

    public boolean isAppearanceDelayed() {
        return System.currentTimeMillis() < this.appearanceDelayEndTime;
    }

    public boolean shouldRender() {
        if (!AbstractElement.isEditor() && this.loadOncePerSession && this.shouldHideOncePerSessionElement()) {
            return false;
        }
        if (this.isAppearanceDelayed() && !AbstractElement.isEditor()) {
            return false;
        }
        boolean b = this._shouldRender();
        if (!AbstractElement.isEditor() && !b && this.fadeOutStarted && !this.fadeOutFinished) {
            return true;
        }
        return b;
    }

    protected boolean _shouldRender() {
        if (!this.loadingRequirementsMet()) {
            return false;
        }
        return this.visible;
    }

    public boolean loadingRequirementsMet() {
        if (AbstractElement.isEditor()) {
            return true;
        }
        return this.loadingRequirementContainer.requirementsMet();
    }

    public boolean shouldHideOncePerSessionElement() {
        return Objects.requireNonNullElse(this.getMemory().getBooleanProperty("hide_once_per_session_element"), false);
    }

    public void setHideOncePerSessionElement() {
        this.getMemory().putPropertyIfAbsent("hide_once_per_session_element", true);
    }

    @NotNull
    public class_2561 getDisplayName() {
        if (this.customElementLayerName != null) {
            return class_2561.method_43470((String)this.customElementLayerName);
        }
        return this.builder.getDisplayName(this);
    }

    @NotNull
    public RuntimePropertyContainer getMemory() {
        if (this.cachedMemory == null) {
            this.cachedMemory = ElementMemories.getMemory(this.getInstanceIdentifier());
        }
        return this.cachedMemory;
    }

    public static String fixBackslashPath(String path) {
        if (path != null) {
            return path.replace("\\", "/");
        }
        return null;
    }

    protected static boolean isEditor() {
        return LayoutEditorScreen.getCurrentInstance() != null;
    }

    @Nullable
    public static class_437 getScreen() {
        if (LayoutEditorScreen.getCurrentInstance() != null) {
            return LayoutEditorScreen.getCurrentInstance();
        }
        return class_310.method_1551().field_1755;
    }

    public static int getScreenWidth() {
        class_437 s = AbstractElement.getScreen();
        return s != null ? s.field_22789 : 0;
    }

    public static int getScreenHeight() {
        class_437 s = AbstractElement.getScreen();
        return s != null ? s.field_22790 : 0;
    }

    @Nullable
    public static AbstractElement getElementByInstanceIdentifier(String identifier) {
        identifier = identifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
        if (LayoutEditorScreen.getCurrentInstance() != null) {
            AbstractEditorElement editorElement = LayoutEditorScreen.getCurrentInstance().getElementByInstanceIdentifier(identifier);
            if (editorElement != null) {
                return editorElement.element;
            }
        } else {
            ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getActiveLayer();
            if (layer != null) {
                return layer.getElementByInstanceIdentifier(identifier);
            }
        }
        return null;
    }

    @NotNull
    public static class_2561 buildComponent(@NotNull String serializedComponentOrPlainText) {
        if (!(serializedComponentOrPlainText = PlaceholderParser.replacePlaceholders(serializedComponentOrPlainText)).startsWith("{") && !serializedComponentOrPlainText.startsWith("[")) {
            return class_2561.method_43470((String)serializedComponentOrPlainText);
        }
        try {
            class_5250 c = AbstractElement.deserializeComponentFromJson(serializedComponentOrPlainText);
            if (c != null) {
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return class_2561.method_43470((String)serializedComponentOrPlainText);
    }

    @Nullable
    protected static class_5250 deserializeComponentFromJson(@NotNull String json) {
        try {
            JsonElement jsonElement = JsonParser.parseString((String)json);
            return jsonElement == null ? null : AbstractElement.deserializeComponent(jsonElement);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to deserialize Component!", (Throwable)ex);
            return null;
        }
    }

    private static class_5250 deserializeComponent(JsonElement jsonElement) {
        Object object = class_8824.field_46597.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow();
        if (object instanceof class_5250) {
            class_5250 m = (class_5250)object;
            return m;
        }
        throw new IllegalStateException("Deserialized component was not a MutableComponent!");
    }

    public void method_25365(boolean var1) {
    }

    public boolean method_25370() {
        return false;
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 narrationElementOutput) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("AbstractElements are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("AbstractElements are not navigatable!");
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return false;
    }

    public static enum AppearanceDelay {
        NO_DELAY("no_delay"),
        FIRST_TIME("first_time"),
        EVERY_TIME("every_time");

        public final String name;

        private AppearanceDelay(String name) {
            this.name = name;
        }

        @Nullable
        public static AppearanceDelay getByName(@NotNull String name) {
            for (AppearanceDelay d : AppearanceDelay.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return null;
        }
    }

    public static enum Fading {
        NO_FADING("no_fading"),
        FIRST_TIME("first_time"),
        EVERY_TIME("every_time");

        private final String name;

        private Fading(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public static Fading getByName(@NotNull String name) {
            for (Fading mode : Fading.values()) {
                if (!mode.getName().equals(name)) continue;
                return mode;
            }
            return null;
        }
    }

    public static enum Alignment {
        LEFT("left"),
        RIGHT("right"),
        CENTERED("centered");

        public final String key;

        private Alignment(String key) {
            this.key = key;
        }

        public static Alignment getByName(@NotNull String name) {
            for (Alignment a : Alignment.values()) {
                if (!a.key.equals(name)) continue;
                return a;
            }
            return null;
        }
    }
}

